/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.api.constants.OptionType;
import noppes.npcs.api.handler.data.IDialogOption;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.controllers.data.Dialog;

public class DialogOption
implements IDialogOption {
    public String command = "";
    public int optionColor = 0xE0E0E0;
    public int slot = -1;
    public int iconId = 0;
    public OptionType optionType = OptionType.DIALOG_OPTION;
    public String title = "Talk";
    public final List<OptionDialogID> dialogs = new ArrayList<OptionDialogID>();

    public Dialog getDialog(EntityPlayer player) {
        if (!this.hasDialogs() || player == null) {
            return null;
        }
        DialogController dData = DialogController.instance;
        for (OptionDialogID od : this.dialogs) {
            if (!dData.hasDialog(od.dialogId) || !od.availability.isAvailable(player)) continue;
            return dData.get(od.dialogId);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.title;
    }

    @Override
    public int getSlot() {
        return this.slot;
    }

    @Override
    public int getType() {
        return this.optionType.get();
    }

    public boolean hasDialogs() {
        return !this.dialogs.isEmpty() && this.optionType == OptionType.DIALOG_OPTION;
    }

    public boolean isAvailable(EntityPlayer player) {
        if (this.optionType == OptionType.DISABLED) {
            return false;
        }
        if (this.optionType != OptionType.DIALOG_OPTION) {
            return true;
        }
        Dialog dialog = this.getDialog(player);
        return dialog != null && dialog.availability.isAvailable(player);
    }

    public void load(NBTTagCompound compound) {
        if (compound != null) {
            this.title = compound.func_74779_i("Title");
            this.optionColor = compound.func_74762_e("DialogColor");
            this.iconId = compound.func_74762_e("IconId");
            this.optionType = OptionType.get(compound.func_74762_e("OptionType"));
            this.command = compound.func_74779_i("DialogCommand");
            if (this.optionColor == 0) {
                this.optionColor = 0xE0E0E0;
            }
            this.dialogs.clear();
            if (compound.func_150297_b("Dialog", 3)) {
                this.dialogs.add(new OptionDialogID(compound.func_74762_e("Dialog")));
            } else if (compound.func_150297_b("Dialogs", 9)) {
                for (int i = 0; i < compound.func_150295_c("Dialogs", 10).func_74745_c(); ++i) {
                    this.dialogs.add(new OptionDialogID(compound.func_150295_c("Dialogs", 10).func_150305_b(i)));
                }
            }
        }
    }

    public NBTTagCompound save() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("Title", this.title);
        compound.func_74768_a("OptionType", this.optionType.get());
        compound.func_74768_a("DialogColor", this.optionColor);
        compound.func_74768_a("IconId", this.iconId);
        compound.func_74778_a("DialogCommand", this.command);
        NBTTagList list = new NBTTagList();
        for (OptionDialogID od : this.dialogs) {
            list.func_74742_a((NBTBase)od.getNBT());
        }
        compound.func_74782_a("Dialogs", (NBTBase)list);
        return compound;
    }

    public void replaceDialogIDs(int oldId, int newId) {
        ArrayList<OptionDialogID> newDialogs = new ArrayList<OptionDialogID>();
        boolean added = false;
        for (OptionDialogID od : this.dialogs) {
            if (od.dialogId == oldId) {
                od.dialogId = newId;
                added = true;
            }
            newDialogs.add(od);
        }
        if (added) {
            this.dialogs.clear();
            this.dialogs.addAll(newDialogs);
        }
    }

    public void upPos(int dialogId) {
        ArrayList<OptionDialogID> newDialogs = new ArrayList<OptionDialogID>();
        boolean added = false;
        OptionDialogID old = null;
        for (OptionDialogID od : this.dialogs) {
            if (od.dialogId == dialogId && old != null) {
                newDialogs.remove(old);
                newDialogs.add(od);
                newDialogs.add(old);
                added = true;
                continue;
            }
            old = od;
            newDialogs.add(od);
        }
        if (added) {
            this.dialogs.clear();
            this.dialogs.addAll(newDialogs);
        }
    }

    public void addDialog(int dialogId) {
        OptionDialogID od = new OptionDialogID(dialogId);
        this.dialogs.add(od);
    }

    public DialogOption copy() {
        DialogOption newDO = new DialogOption();
        newDO.load(this.save());
        return newDO;
    }

    public void downPos(int dialogId) {
        ArrayList<OptionDialogID> newDialogs = new ArrayList<OptionDialogID>();
        boolean added = false;
        OptionDialogID found = null;
        for (OptionDialogID od : this.dialogs) {
            if (od.dialogId == dialogId && found == null) {
                found = od;
                continue;
            }
            newDialogs.add(od);
            if (found == null || added) continue;
            newDialogs.add(found);
            added = true;
        }
        if (found != null && !added) {
            newDialogs.add(found);
            added = true;
        }
        if (added) {
            this.dialogs.clear();
            this.dialogs.addAll(newDialogs);
        }
    }

    public static class OptionDialogID {
        public int dialogId;
        public Availability availability;

        public OptionDialogID(int id) {
            this.dialogId = id;
            this.availability = new Availability();
        }

        public OptionDialogID(NBTTagCompound compound) {
            this.dialogId = compound.func_74762_e("DialogId");
            this.availability = new Availability();
            this.availability.load(compound);
        }

        public NBTTagCompound getNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("DialogId", this.dialogId);
            this.availability.save(compound);
            return compound;
        }

        public String toString() {
            return "OptionDialogID: " + this.dialogId + "; " + this.availability.toString();
        }
    }
}

